IF  EXISTS (SELECT * FROM SYS.TRIGGERS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[TRG_EST_TRIB_CONF_GRP_ALT_HIST]'))
DROP TRIGGER [dbo].[TRG_EST_TRIB_CONF_GRP_ALT_HIST]
GO

CREATE  TRIGGER [dbo].[TRG_EST_TRIB_CONF_GRP_ALT_HIST] 	ON [dbo].[EST_TRIB_CONF_GRP]
after INSERT, UPDATE, DELETE
AS

Declare @Tipo tinyint

set @Tipo =2 --Delete 

IF NOT EXISTS (SELECT * fROM DELETED) 
	set @Tipo =0 --Insert
	
IF EXISTS (SELECT * fROM INSERTED) 
	set @Tipo =1 --Update
	
if @Tipo =2 
begin
	insert into EST_TRIB_CONF_GRP_ALT_HIST (CD_EMP, CD_CTR, DS_CONF_TRIB,CD_REGIAO_FISCAL,OPERACAO,CD_USU,DT_CAD)
	select 
		  CD_EMP
		, CD_CTR
		, DS_CONF_TRIB
		, CD_REGIAO_FISCAL
		, @Tipo OPERACAO
		, CD_USU
		, getdate() DT_CAD
	from 
		DELETED 
end
else
begin
	insert into EST_TRIB_CONF_GRP_ALT_HIST (CD_EMP, CD_CTR, DS_CONF_TRIB,CD_REGIAO_FISCAL,OPERACAO,CD_USU,DT_CAD)
	select 
		  CD_EMP
		, CD_CTR
		, DS_CONF_TRIB
		, CD_REGIAO_FISCAL
		, @Tipo OPERACAO
		, CD_USU
		, getdate() DT_CAD
	from 
		INSERTED 
end
GO

ALTER TABLE [dbo].[EST_TRIB_CONF_GRP] ENABLE TRIGGER [TRG_EST_TRIB_CONF_GRP_ALT_HIST]
GO


